/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.autoupdate;

import com.quantumdata.autoupdate.Device88X;
import com.quantumdata.autoupdate.WebInterfaceException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class WebInterface {
    private static final String UPGRADE_STATUS_FIELD = "QDUpgrade-status";
    private static final String UPGRADE_FILE = "QDUpgrade-file";
    private static final String UPGRADE_VERSION = "QDVersion-number";
    public static final String UPGRADE_AVAIL = "UPGRADE_AVAILABLE";
    public static final String SAME_VERSION = "SAME_VERSION";
    public static final String NO_UPGRADE = "NO_UPGRADE_AVAILABLE";
    public static final String HOST_NOT_ACCESSIBLE = "HOST_NOT_ACCESSIBLE";
    public static final int HTTP_GET_URL = 0;
    public static final int HTTP_DOWNLOAD_URL = 1;
    private URL m_quantumDataURL;
    private HttpURLConnection m_QDconnection;
    private String m_URLstring = "";
    private String m_UpgradeStatus;
    private String m_UpgradeFile;
    private String m_UpgradeVersion;

    public WebInterface(Device88X device88X, String string, int n) throws MalformedURLException {
        if (n == 1) {
            this.m_URLstring = string;
        } else {
            this.setURL(device88X, string);
        }
        this.m_quantumDataURL = new URL(this.m_URLstring);
    }

    private String setURL(Device88X device88X, String string) {
        this.m_URLstring = string;
        this.m_URLstring = this.m_URLstring.trim();
        this.m_URLstring = this.m_URLstring + "?";
        this.m_URLstring = this.m_URLstring + "model=" + device88X.getModelNum();
        this.m_URLstring = this.m_URLstring + "&verf=" + device88X.getVerfString();
        this.m_URLstring = this.m_URLstring + "&verg=" + device88X.getVergString();
        System.out.println("URL String: " + this.m_URLstring);
        return this.m_URLstring;
    }

    public String getURL() {
        return this.m_URLstring;
    }

    public String getUpgradeFile() {
        return this.m_UpgradeFile;
    }

    public String getUpgradeStatus() {
        return this.m_UpgradeStatus;
    }

    public String getUpgradeVersion() {
        return this.m_UpgradeVersion;
    }

    public synchronized String checkForUpgrade(JFrame jFrame, JProgressBar jProgressBar, JLabel jLabel) throws WebInterfaceException {
        block8: {
            WebInterfaceException webInterfaceException = new WebInterfaceException();
            this.m_UpgradeFile = "";
            try {
                String string = "Connecting to URL: " + this.m_quantumDataURL.getHost();
                System.out.println(string);
                jLabel.setText(string);
                jFrame.update(jFrame.getGraphics());
                this.m_QDconnection = (HttpURLConnection)this.m_quantumDataURL.openConnection();
                this.m_QDconnection.setDoOutput(true);
                this.m_QDconnection.setDoInput(true);
                this.m_QDconnection.setUseCaches(false);
                this.m_QDconnection.connect();
                jFrame.update(jFrame.getGraphics());
                if (this.m_QDconnection.getResponseCode() != 202 && this.m_QDconnection.getResponseCode() != 200) {
                    this.m_QDconnection.disconnect();
                    webInterfaceException.setWebResponseMessage(this.m_QDconnection.getResponseMessage());
                    webInterfaceException.setWebResponseCode(this.m_QDconnection.getResponseCode());
                    throw webInterfaceException;
                }
                this.m_UpgradeStatus = this.m_QDconnection.getHeaderField(UPGRADE_STATUS_FIELD);
                if (this.m_UpgradeStatus == "" || this.m_UpgradeStatus == null) {
                    this.m_UpgradeStatus = HOST_NOT_ACCESSIBLE;
                }
                webInterfaceException.setUpgradeStatus(this.m_UpgradeStatus);
                System.out.println("Web Returned Status = " + this.m_UpgradeStatus);
                if (this.m_UpgradeStatus == null) {
                    webInterfaceException.setWebResponseMessage("Web site return a status value of \"Null\"");
                    throw webInterfaceException;
                }
                if (this.m_UpgradeStatus.equalsIgnoreCase(SAME_VERSION)) {
                    this.m_UpgradeFile = this.m_QDconnection.getHeaderField(UPGRADE_FILE);
                    this.m_UpgradeVersion = this.m_QDconnection.getHeaderField(UPGRADE_VERSION);
                    System.out.println("Web Upgrade Location = " + this.m_UpgradeFile);
                    System.out.println("Web Upgrade Version = " + this.m_UpgradeVersion);
                    throw webInterfaceException;
                }
                if (this.m_UpgradeStatus.equalsIgnoreCase(NO_UPGRADE)) {
                    throw webInterfaceException;
                }
                this.m_UpgradeFile = this.m_QDconnection.getHeaderField(UPGRADE_FILE);
                this.m_UpgradeVersion = this.m_QDconnection.getHeaderField(UPGRADE_VERSION);
                if (this.m_UpgradeFile == "") {
                    webInterfaceException.setWebErrorMessage("Link to Upgrade File Not Returned by the server");
                    throw webInterfaceException;
                }
                System.out.println("Web Upgrade Location = " + this.m_UpgradeFile);
                System.out.println("Web Upgrade Version = " + this.m_UpgradeVersion);
            }
            catch (IOException iOException) {
                if (this.m_UpgradeFile != "" && this.m_UpgradeFile != null) break block8;
                this.m_UpgradeStatus = HOST_NOT_ACCESSIBLE;
                webInterfaceException.setUpgradeStatus(this.m_UpgradeStatus);
                webInterfaceException.setWebErrorMessage("Could not connect to Server");
                throw webInterfaceException;
            }
        }
        return this.m_UpgradeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void downloadUpdate(JFrame jFrame, JProgressBar jProgressBar, JLabel jLabel, Device88X device88X) throws WebInterfaceException {
        WebInterfaceException webInterfaceException = new WebInterfaceException();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            String string = "<html><body><p align=\"center\">Downloading file from: " + this.m_quantumDataURL.getHost() + "</p></body></html>";
            System.out.println(string);
            jLabel.setText(string);
            jFrame.update(jFrame.getGraphics());
            this.m_QDconnection = (HttpURLConnection)this.m_quantumDataURL.openConnection();
            this.m_QDconnection.setDoOutput(true);
            this.m_QDconnection.setDoInput(true);
            this.m_QDconnection.setUseCaches(false);
            this.m_QDconnection.connect();
            jFrame.update(jFrame.getGraphics());
            if (this.m_QDconnection.getResponseCode() != 202 && this.m_QDconnection.getResponseCode() != 200) {
                this.m_QDconnection.disconnect();
                webInterfaceException.setWebResponseMessage(this.m_QDconnection.getResponseMessage());
                webInterfaceException.setWebResponseCode(this.m_QDconnection.getResponseCode());
                throw webInterfaceException;
            }
            int n = this.m_QDconnection.getContentLength();
            String[] stringArray = this.m_quantumDataURL.getFile().split("/");
            String string2 = stringArray[Array.getLength(stringArray) - 1];
            String string3 = "./downloads";
            string2 = string3 + File.separator + string2;
            File file = new File(string3);
            if (!file.exists()) {
                file.mkdir();
            }
            file = null;
            file = new File(string2);
            device88X.setZipFilePath(string2);
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            inputStream = this.m_QDconnection.getInputStream();
            jProgressBar.setMaximum(n);
            byte[] byArray = new byte[1024];
            int n2 = 0;
            int n3 = 0;
            while ((n2 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
                jProgressBar.setValue(n3 += n2);
                jLabel.setText("<html><body><p align=\"center\">Downloading File... " + (int)(jProgressBar.getPercentComplete() * 100.0) + "% Complete</p></body></html>");
                jFrame.update(jFrame.getGraphics());
                Thread.yield();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Download Error:  " + iOException.getMessage(), "Upgrade File Not Found", 0);
            System.out.println("Exiting");
            System.exit(0);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

